Humans = {}
Triggers = {}
Players = {}
KnownDead = {}
VisibleEnemies = {}
VisibleEnemies.size = 0
--
--enums
--
--behaviors
--
FREE 			= "free"
SQUADDY 		= "squaddy"
SQUAD_LEADER 		= "squad_leader"
NPC 			= "npc"
EMPTY 			= ""
--
--specializations
--
SOLDIER			= "soldier"
SNIPER 			= "sniper"
GUARD 			= "guard"
PATROL 			= "patrol"
CIVILIAN 		= "civilian"
PLAYER 			= "player"
VALID_SPECS 	= {SOLDIER,SNIPER,GUARD,PATROL,CIVILIAN,PLAYER}
VALID_BEHAVIORS = {FREE,SQUADDY,SQUAD_LEADER,NPC}
--
WAS_TB 			= 0
ENTER_COMMENT_SAID 	= 0
RT_COMMENT_SAID 	= 0
--
--universal null string
--
NONE 			= "_none"
LAST_REMARK 		= NONE
--
--/enums
--
include("scripts/ai/memory")
include("scripts/ai/ai_proxy")
include("scripts/ai/fighter_rt")
include("scripts/ai/fighter_tb")
include("scripts/ai/trigger_functions")
include("scripts/ai/trigger_utility")
include("scripts/ai/trigger_service")
include("scripts/ai/sounds")
include("scripts/ai/table_values")
include("scripts/ai/service")
-------------------------------------
include("scripts/ai/rpg_system")
include("scripts/ai/interrupt_system")
include("scripts/ai/b_civilian")
include("scripts/ai/b_soldier")
include("scripts/ai/b_squaddy")
include("scripts/ai/b_squad_leader")
include("scripts/ai/b_patrol")
include("scripts/ai/b_sniper")
include("scripts/ai/b_guard")
include("scripts/ai/calls_log")
-------------------------------------

function createTrigger(name,tx,ty,tz,spot_prob,def_prob,eff_rad,exp_rad,dmg)
calls.enter("createTrigger",name)
	log(name, "LUA: created trigger, id", name)
	local newTrigger =
	{
		active = true,
		id = name,
		armed = false,
		countdown = false,
		countdown_start_time = 0,
		defuse = false,
		defuse_start_time = 0,
		time_to_defuse = 10,
		saper_defuse_time = 10, --    
		
		type = "TNT_trigger", 
		activate_radius = 0.02,
		position = {x=tx, y=ty, z=tz, f=1 }, 
		spotting_probability = spot_prob,
		defuse_probability = def_prob,
		shout_radius = 10,
		saper = "",
		team = "",
		effect_radius = eff_rad,
		explode_radius = exp_rad,
		damage = dmg,
		think = "TNT_think"
	}
	Triggers[name] = newTrigger
calls.leave("createTrigger",name)
end

function sendSaper(id,bomb_id)
calls.enter("sendSaper",id)
	local trigger = Triggers[bomb_id]
	local human = Humans[id]
	if (human ~= nil) or (trigger~=nil) then
		if(trigger.saper == "") then
			trigger.saper = id
			trigger.saper_send_time = time()
			log("bomb_id", " ", id, " ")
			
			--fighter.gotoBomb(id,bomb_id)
calls.leave("sendSaper",1)
			return true
		else
			log("bomb_id", "  ")
calls.leave("sendSaper",0)
			return false
		end
	else
		log("main", "  ", id, "   ", bomb_id, "  ")
calls.leave("sendSaper",0)
		return false
	end
end

function addHuman(name)
calls.enter("addHuman",name)
	log(name, "LUA","added human", "id:", name)
	if(Humans[name]) then
		log(name, "Already initialized")		
	else
		log(name, "NOT initialized")
	end
	local human =
	{
		id = name,
		behavior = "", 
		specialization = "",
		params = "",
	}
	
	Humans[name] = deepcopy(human)
	memory.init(name)
calls.leave("addHuman",name)
end

function killHuman(name)
calls.enter("killHuman",name)
	if((not isGameInRT()) and isPersonTurn(name) and Humans[name]) then
		endOfTurn(name)
	end
	log(name, "LUA: killed human, id = ", name)
	local side = team(name)
	Humans[name] = nil
	if(isValid(CUR_MISSION.Name) and isValid(side)) then
		CUR_MISSION.Units[side] = service.getPlayerUnits(side)

		local findMerc = function(index,value)
			if(value==name) then
				table.remove(CUR_MISSION.Mercs,index)
				return(1)
			end
		end

		if((side==PLAYER) and isValid(CUR_MISSION.Mercs)) then
			table.foreach(CUR_MISSION.Mercs,findMerc)
		end
	end

	local checkReferences = function(id,data)
		memory.removeKnownEnemy(id,name)
		sounds.removeSoundsFrom(id,name)
		service.removeFromVisibleL(id,name)
		if(Humans[id].known == name) then
			Humans[id].known = NONE
		end
		if(Humans[id].going_target == name) then
			Humans[id].going_target = NONE
		end
		if(Humans[id].leader == name) then
			Humans[id].leader = NONE
		end
		if(Humans[id].assigned_target == name) then
			Humans[id].assigned_target = NONE
		end
		if(Humans[id].hurt == name) then
			Humans[id].hurt = NONE
		end
		if(Humans[id].current_target == name) then
			Humans[id].current_target = NONE
		end
	end

	table.foreach(Humans,checkReferences)
calls.leave("killHuman",name)
end

function activateTrigger(id)
calls.enter("activateTrigger",id)
	log(id, "LUA: activate trigger")
	if (id ~= nil) then
		Triggers[id].active = true
	end
calls.leave("activateTrigger",id)
end

function deactivateTrigger(id)
calls.enter("deactivateTrigger",id)
	log(id, "LUA: deactivate trigger")
	if (id ~= nil) then
		Triggers[id].active = false
	end
calls.leave("deactivateTrigger",id)
end

function getTriggerState(id)
calls.enter("getTriggerState",id)
	log(id, "LUA: activate trigger")
calls.leave("getTriggerState",id)
	if (id ~= nil) then
		return	Triggers[id].active
	else
		return false
	end
end

function setBehaviorToNPC(name_)
calls.enter("setBehaviorToNPC",name_)
	if(Humans[name_]) then
		log("main", "LUA: setBehaviorToNPC",name_)
		Humans[name_].behavior = "NPC"
	end
calls.leave("setBehaviorToNPC",name_)
end

function setBehavior(name_, specialization_, behavior_, params_, modal_state_)
calls.enter("setBehavior", name_)
	if(Humans[name_]) then
		log("main", "LUA: setBehavior ", name_, specialization_, behavior_, params_, modal_state_)
		Humans[name_].behavior = behavior_
		Humans[name_].specialization = specialization_
		Humans[name_].params = params_
	end
calls.leave("setBehavior", name_)
end

function isInShootTrigger(id)
calls.enter("isInShootTrigger",id)
	local ret = isValid(trigger_service.isPersonInShootPosition2(id))
calls.leave("isInShootTrigger",id)
	return ret
end

function isInHMGTrigger(id)
calls.enter("isInHMGTrigger",id)
	local ret = isValid(trigger_service.isPersonInHMGPosition(id))
calls.leave("isInHMGTrigger",id)
	return ret
end

function isNearHMGTrigger(id)
calls.enter("isNearHMGTrigger",id)
	local ret = isValid(trigger_service.isPersonNearHMGPosition(id))
calls.leave("isNearHMGTrigger",id)
	return ret
end

function isUnitValid(id)
	return(isValid(id) and (not disappeared(id)))
end

function IsAlive(id)
	return(isUnitValid(id) and isAlive(id))
end

function trigger_think(time)
calls.enter("trigger_think",time)
	local checkForFreeze = function(index, human)
		local id = human.id
		if((not service.isPlayer(id)) and 
			(Humans[id].orders>6) and
			IsAlive(id) and
			isPersonTurn(id)
			) then
			log(id,"*** Orders too big! Try stop...")
	                stop(id)
	                if(not isGameInRT()) then
	                	endOfTurn(id)
	                end
		end
	end
	-------------------------------------------------
	local func = function(index, trigger)
		local tf = trigger_functions[trigger.think]
		if(isValid(tf)) then
			log(index, "think started for ", index, " at ", time)
			trigger_utility.init(index)
			tf(index, time)
		end
	end
	-------------------------------------------------
	local func2 = function(index, trigger)
		local tf = global_trigger_functions[trigger.think]
		if(isValid(tf)) then
			log(index, "think started for ", index, " at ", time)
			trigger_utility.init(index)
			tf(index, time)
		end
	end
	table.foreach(Humans, checkForFreeze)
	table.foreach(Triggers, func)
	table.foreach(Triggers, func2)
	trigger_service.person_observer.forget(time)
calls.leave("trigger_think",time)
end

function death(id)
calls.enter("death",id)
        if (CUR_MISSION.Name ~= nil) then
                Sectors[CUR_MISSION.Name].onKill()
        end
	trigger_service.hurt_observer.addDeath(id)
calls.leave("death",id)
end

function getPlayerZones(player_id)
calls.enter("getPlayerZones",player_id)
	local zones = {}
	local player = Players[player_id]
	if(isValid(player)) then
		zones = player.zones
	end
calls.leave("getPlayerZones",player_id)
	return zones
end

function mergeTbl(to, from)
	local local_merge = function(index, value)
		if ( type(value) == "table") then
			if (type(to[index]) == "table") then
				mergeTbl(to[index], value)
			else
				to[index] = value
			end
		else
			to[index] = value
		end
	end
	table.foreach(from, local_merge)
end

function checkTargetsList()
calls.enter("checkTargetsList")
	local res = true
	
	local check = function(index, value)
		if(healthOK(value.id) and memory.lastSeenPresent(value.id)) then
			log("Visible","lastSeenPresent for ",value.id)
			res = false
			return(1)
		end
	end
        
	table.foreach(Humans, check)

	log("Visible","Result:",res)
calls.leave("checkTargetsList")		
	return(res)
end

